<?php

namespace Blueskytechco\PageBuilderCustom\Setup;

use Blueskytechco\PageBuilderCustom\Model\BlueskytechcoPageBuilderCache;
use Blueskytechco\PageBuilderCustom\Model\BlueskytechcoPageBuilderCacheFactory;
use Magento\Framework\Module\Setup\Migration;
use Magento\Framework\Setup\InstallDataInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;

class InstallData implements InstallDataInterface
{
    private $_pageBuilderCacheFactory;
    private $state;

    public function __construct(
        \Blueskytechco\PageBuilderCustom\Model\BlueskytechcoPageBuilderCacheFactory $pageBuilderCacheFactory,
        \Magento\Framework\App\State $state
    ) {
        $this->_pageBuilderCacheFactory = $pageBuilderCacheFactory;
        $this->state = $state;
    }

    public function install(ModuleDataSetupInterface $setup, ModuleContextInterface $context)
    {
        try {
            $this->state->setAreaCode('adminhtml');
        } catch (\Exception $e) {
            /* Do nothing, it's OK */
        }

        $data = [];

        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_staticmenu',
            'serialize_data' => '{"name":"staticmenu","label":"Static Menu","icon":"icon-pagebuilder-staticmenu","form":"pagebuilder_staticmenu_form","menu_section":"blueskytechco_page_builder_custom_elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"stacked"},"title":{"default":"Menu"}}},"component":"Magento_PageBuilder\/js\/content-type-collection","preview_component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/staticmenu\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master-collection","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"stacked":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"css_classes","filter":[]},"tag":[]},"title":{"style":[],"attributes":[],"html":{"var":"title","converter":null,"preview_converter":null},"css":[],"tag":[]}},"converters":[],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/staticmenu\/stacked\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/staticmenu\/stacked\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":[],"additional_data":[],"is_system":true}'
        ];

        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_newsletter',
            'serialize_data' => '{"name":"newsletter","label":"Newsletter","icon":"icon-pagebuilder-newsletter","form":"pagebuilder_newsletter_form","menu_section":"blueskytechco_page_builder_custom_elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"default"},"layout":{"default":"style_1"},"placeholder":{"default":"Your email address"},"subscribe":{"default":"Subscribe"}}},"component":"Magento_PageBuilder\/js\/content-type","preview_component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/newsletter\/preview","master_component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/newsletter\/master","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"default":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"layout","name":"data-layout","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"css_classes","filter":[]},"tag":[]},"placeholder":{"style":[],"attributes":[{"var":"placeholder","name":"placeholder","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":[],"tag":[]},"subscribe":{"style":[],"attributes":[],"html":{"var":"subscribe","converter":null,"preview_converter":null},"css":[],"tag":[]}},"converters":[],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/newsletter\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/newsletter\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":[],"additional_data":[],"is_system":true}'
        ];

        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_button-item',
            'serialize_data' => '{"name":"button-item","label":"Button","icon":"icon-pagebuilder-button","form":"pagebuilder_button_item_form","menu_section":"elements","fields":{"default":{"text_align":{"default":"center"},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"default"},"button_text":{"default":""},"button_type":{"default":"pagebuilder-button-primary"}}},"component":"Magento_PageBuilder\/js\/content-type-collection","preview_component":"Magento_PageBuilder\/js\/content-type\/button-item\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":["buttons"],"appearances":{"default":{"elements":{"main":{"style":[{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/content-type\/button-item\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"css_classes","filter":[]},"tag":[]},"link":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"button_link","name":null,"converter":null,"preview_converter":null,"persistence_mode":"read","reader":"Magento_PageBuilder\/js\/property\/link"},{"var":"button_link","name":"href","converter":"Magento_PageBuilder\/js\/converter\/attribute\/link-href","preview_converter":null,"persistence_mode":"write","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"button_link","name":"target","converter":"Magento_PageBuilder\/js\/converter\/attribute\/link-target","preview_converter":null,"persistence_mode":"write","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"button_link","name":"data-link-type","converter":"Magento_PageBuilder\/js\/converter\/attribute\/link-type","preview_converter":null,"persistence_mode":"write","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"button_type","filter":[]},"tag":[]},"empty_link":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[],"html":[],"css":{"var":"button_type","filter":[]},"tag":[]},"link_text":{"style":[],"attributes":[],"html":{"var":"button_text","converter":"Magento_PageBuilder\/js\/converter\/html\/tag-escaper","preview_converter":null},"css":[],"tag":[]}},"converters":[],"preview_template":"Magento_PageBuilder\/content-type\/button-item\/default\/preview","master_template":"Magento_PageBuilder\/content-type\/button-item\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":[],"additional_data":[],"is_system":false}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_staticmenu-item',
            'serialize_data' => '{"name":"staticmenu-item","label":"Static Menu","icon":"icon-pagebuilder-staticmenu","form":"pagebuilder_staticmenu_item_form","menu_section":"blueskytechco_page_builder_custom_elements","fields":{"default":{"text_align":{"default":"center"},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"default"},"staticmenu_text":{"default":""}}},"component":"Magento_PageBuilder\/js\/content-type-collection","preview_component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/staticmenu-item\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":["staticmenu"],"appearances":{"default":{"elements":{"main":{"style":[],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"css_classes","filter":[]},"tag":[]},"link":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"staticmenu_link","name":null,"converter":null,"preview_converter":null,"persistence_mode":"read","reader":"Magento_PageBuilder\/js\/property\/link"},{"var":"staticmenu_link","name":"href","converter":"Magento_PageBuilder\/js\/converter\/attribute\/link-href","preview_converter":null,"persistence_mode":"write","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"staticmenu_link","name":"target","converter":"Magento_PageBuilder\/js\/converter\/attribute\/link-target","preview_converter":null,"persistence_mode":"write","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"staticmenu_link","name":"data-link-type","converter":"Magento_PageBuilder\/js\/converter\/attribute\/link-type","preview_converter":null,"persistence_mode":"write","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":[],"tag":[]},"empty_link":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[],"html":[],"css":[],"tag":[]},"link_text":{"style":[],"attributes":[],"html":{"var":"staticmenu_text","converter":"Magento_PageBuilder\/js\/converter\/html\/tag-escaper","preview_converter":null},"css":[],"tag":[]}},"converters":[],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/staticmenu-item\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/staticmenu-item\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":[],"additional_data":[],"is_system":false}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_iconbox',
            'serialize_data' => '{"name":"iconbox","label":"Icon Box","icon":"icon-pagebuilder-iconbox","form":"pagebuilder_iconbox_form","menu_section":"blueskytechco_page_builder_custom_elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"default"},"iconhtml":{"default":""},"font_size":{"default":"36px"},"iconposition":{"default":"left"},"justify_content":{"default":"flex-start"},"viewtype":{"default":"default"},"title":{"default":"This is the heading"},"short_description":{"default":"Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo."}}},"component":"Magento_PageBuilder\/js\/content-type","preview_component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/iconbox\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"default":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"iconposition","name":"data-icon-box-position","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"viewtype","name":"data-icon-box-view","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"justify_content","name":"data-justify-content","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"css_classes","filter":[]},"tag":[]},"iconfontsize":{"style":[{"var":"font_size","name":"font_size","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"}],"attributes":[],"html":[],"css":[],"tag":[]},"iconhtml":{"style":[],"attributes":[],"html":{"var":"iconhtml","converter":null,"preview_converter":null},"css":[],"tag":[]},"title":{"style":[],"attributes":[],"html":{"var":"title","converter":null,"preview_converter":null},"css":[],"tag":[]},"short_description":{"style":[],"attributes":[],"html":{"var":"short_description","converter":null,"preview_converter":null},"css":[],"tag":[]},"link":{"style":[],"attributes":[{"var":"link_url","name":null,"converter":null,"preview_converter":null,"persistence_mode":"read","reader":"Magento_PageBuilder\/js\/property\/link"},{"var":"link_url","name":"href","converter":"Magento_PageBuilder\/js\/converter\/attribute\/link-href","preview_converter":null,"persistence_mode":"write","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"link_url","name":"target","converter":"Magento_PageBuilder\/js\/converter\/attribute\/link-target","preview_converter":null,"persistence_mode":"write","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"link_url","name":"data-link-type","converter":"Magento_PageBuilder\/js\/converter\/attribute\/link-type","preview_converter":null,"persistence_mode":"write","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"title_attribute","name":"title","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":[],"tag":[]},"empty_link":{"style":[],"attributes":[],"html":[],"css":[],"tag":[]}},"converters":[],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/iconbox\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/iconbox\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":{"mobile":{"form":"pagebuilder_iconbox_mobile_form","fields":{"default":{"margins_and_padding":{"default":""}}}},"tablet":{"form":"pagebuilder_iconbox_tablet_form","fields":{"default":{"margins_and_padding":{"default":""}}}}},"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_blog_posts',
            'serialize_data' => '{"name":"blog_posts","label":"Blog Posts","icon":"icon-pagebuilder-blog-posts","form":"pagebuilder_blog_posts_form","menu_section":"blueskytechco_page_builder_custom_elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"grid"},"template_id":{"default":"default"},"title":{"default":""},"short_description":{"default":""},"space_between_item":{"default":"30"},"image_hover_effects":{"default":"none"},"sort_order":{"default":""},"category_id":{"default":""},"posts_tag":{"default":"0"},"posts_author":{"default":"0"},"publish_date_from":{"default":""},"publish_date_to":{"default":""},"number_posts":{"default":""}},"carousel-appearance":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"carousel"},"template_id":{"default":"default"},"title":{"default":""},"short_description":{"default":""},"space_between_item":{"default":"30"},"image_hover_effects":{"default":"none"},"template_carousel_id":{"default":"carousel"},"sort_order":{"default":""},"category_id":{"default":""},"posts_tag":{"default":"0"},"posts_author":{"default":"0"},"publish_date_from":{"default":""},"publish_date_to":{"default":""},"number_posts":{"default":""},"carousel_mode":{"default":"default"},"autoplay":{"default":"false"},"autoplay_speed":{"default":"4000"},"is_infinite":{"default":"false"},"show_arrows":{"default":"false"},"show_dots":{"default":"false"},"slick_rows":{"default":"1"},"margin_item":{"default":"30"},"col_xxl":{"default":"6"},"col_xl":{"default":"5"},"col_lg":{"default":"4"},"col_md":{"default":"3"},"col_sm":{"default":"2"},"col_xs":{"default":"2"}}},"component":"Magento_PageBuilder\/js\/content-type","preview_component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/blog-posts\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"grid":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":"Magento_PageBuilder\/js\/converter\/style\/color","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":{"var":"html","converter":null,"preview_converter":"Magento_PageBuilder\/js\/converter\/attribute\/preview\/store-id"},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[{"name":"widget_directive","component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/blog-posts\/mass-converter\/widget-directive","config":{"html_variable":"html"}}],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/blog-posts\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/blog-posts\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"},"carousel":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":"Magento_PageBuilder\/js\/converter\/style\/color","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay","name":"data-autoplay","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay_speed","name":"data-autoplay-speed","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"is_infinite","name":"data-infinite-loop","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_arrows","name":"data-show-arrows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_dots","name":"data-show-dots","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"carousel_mode","name":"data-carousel-mode","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"slick_rows","name":"data-slick-rows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xxl","name":"data-col-xxl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xl","name":"data-col-xl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_lg","name":"data-col-lg","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_md","name":"data-col-md","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_sm","name":"data-col-sm","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xs","name":"data-col-xs","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"name":"data-center-padding","value":"90px","static":true}],"html":{"var":"html","converter":null,"preview_converter":"Magento_PageBuilder\/js\/converter\/attribute\/preview\/store-id"},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[{"name":"widget_directive","component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/blog-posts\/mass-converter\/carousel-widget-directive","config":{"html_variable":"html"}}],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/blog-posts\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/blog-posts\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":null,"form":"pagebuilder_blog_posts_carousel_form"}},"breakpoints":{"mobile":{"form":"pagebuilder_blog_posts_mobile_form","fields":{"default":{"margins_and_padding":{"default":""}}}},"tablet":{"form":"pagebuilder_blog_posts_tablet_form","fields":{"default":{"margins_and_padding":{"default":""}}}}},"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_column-group',
            'serialize_data' => '{"name":"column-group","label":"Column Group","icon":"icon-pagebuilder-column","form":"","menu_section":"layout","fields":{"default":[]},"component":"Magento_PageBuilder\/js\/content-type-collection","preview_component":"Magento_PageBuilder\/js\/content-type\/column-group\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master-collection","allowed_parents":["row","tab-item"],"appearances":{"default":{"elements":{"main":{"style":[],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"grid_size","name":"data-grid-size","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":[],"tag":[]}},"converters":[],"preview_template":"Magento_PageBuilder\/content-type\/column-group\/default\/preview","master_template":"Magento_PageBuilder\/content-type\/column-group\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":[],"additional_data":[],"is_system":false}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_instagram',
            'serialize_data' => '{"name":"instagram","label":"Instagram","icon":"icon-pagebuilder-instagram","form":"pagebuilder_instagram_form","menu_section":"blueskytechco_page_builder_custom_elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"grid"},"image_format":{"default":""},"title":{"default":""},"short_description":{"default":""},"image_hover_effects":{"default":"none"},"show_captions":{"default":"false"},"show_instagram_icon":{"default":"false"},"margin_grid_vertical":{"default":"10"},"col_xxl":{"default":"2"},"col_xl":{"default":"15"},"col_lg":{"default":"3"},"col_md":{"default":"4"},"col_sm":{"default":"6"},"col_xs":{"default":"6"}},"carousel-appearance":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"carousel"},"image_format":{"default":""},"title":{"default":""},"short_description":{"default":""},"image_hover_effects":{"default":"none"},"show_captions":{"default":"false"},"show_instagram_icon":{"default":"false"},"margin_grid_vertical":{"default":"10"},"col_xxl":{"default":"6"},"col_xl":{"default":"5"},"col_lg":{"default":"4"},"col_md":{"default":"3"},"col_sm":{"default":"2"},"col_xs":{"default":"2"},"carousel_mode":{"default":"default"},"autoplay":{"default":"false"},"autoplay_speed":{"default":"4000"},"is_infinite":{"default":"false"},"show_arrows":{"default":"false"},"show_dots":{"default":"true"},"slick_rows":{"default":"1"},"margin_item":{"default":"30"}}},"component":"Magento_PageBuilder\/js\/content-type","preview_component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/instagram\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"grid":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":"Magento_PageBuilder\/js\/converter\/style\/color","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":{"var":"html","converter":null,"preview_converter":"Magento_PageBuilder\/js\/converter\/attribute\/preview\/store-id"},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[{"name":"widget_directive","component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/instagram\/mass-converter\/widget-directive","config":{"html_variable":"html"}}],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/instagram\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/instagram\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"},"carousel":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":"Magento_PageBuilder\/js\/converter\/style\/color","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay","name":"data-autoplay","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay_speed","name":"data-autoplay-speed","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"is_infinite","name":"data-infinite-loop","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_arrows","name":"data-show-arrows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_dots","name":"data-show-dots","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"carousel_mode","name":"data-carousel-mode","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"slick_rows","name":"data-slick-rows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xxl","name":"data-col-xxl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xl","name":"data-col-xl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_lg","name":"data-col-lg","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_md","name":"data-col-md","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_sm","name":"data-col-sm","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xs","name":"data-col-xs","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"name":"data-center-padding","value":"90px","static":true}],"html":{"var":"html","converter":null,"preview_converter":"Magento_PageBuilder\/js\/converter\/attribute\/preview\/store-id"},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[{"name":"widget_directive","component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/instagram\/mass-converter\/carousel-widget-directive","config":{"html_variable":"html"}}],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/instagram\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/instagram\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":null,"form":"pagebuilder_instagram_carousel_form"}},"breakpoints":{"mobile":{"form":"pagebuilder_instagram_mobile_form","fields":{"default":{"margins_and_padding":{"default":""}}}},"tablet":{"form":"pagebuilder_instagram_tablet_form","fields":{"default":[]}}},"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_video',
            'serialize_data' => '{"name":"video","label":"Video","icon":"icon-pagebuilder-video","form":"pagebuilder_video_form","menu_section":"media","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"default"},"video_source":{"default":""},"max_width":{"default":""},"autoplay":{"default":"false"}}},"component":"Magento_PageBuilder\/js\/content-type","preview_component":"Magento_PageBuilder\/js\/content-type\/video\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/video\/master","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"default":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"css_classes","filter":[]},"tag":[]},"inner":{"style":[{"var":"max_width","name":"max_width","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"}],"attributes":[],"html":[],"css":[],"tag":[]},"wrapper":{"style":[{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[],"html":[],"css":[],"tag":[]},"video":{"style":[],"attributes":[{"var":"video_source","name":"src","converter":"Magento_PageBuilder\/js\/content-type\/video\/converter\/attribute\/videosrc","preview_converter":"Magento_PageBuilder\/js\/content-type\/video\/converter\/attribute\/videosrc","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay","name":"autoplay","converter":"Magento_PageBuilder\/js\/content-type\/video\/converter\/attribute\/autoplay","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay","name":"muted","converter":"Magento_PageBuilder\/js\/content-type\/video\/converter\/attribute\/autoplay","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":[],"tag":[]}},"converters":[],"preview_template":"Magento_PageBuilder\/content-type\/video\/default\/preview","master_template":"Magento_PageBuilder\/content-type\/video\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":[],"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_heading',
            'serialize_data' => '{"name":"heading","label":"Heading","icon":"icon-pagebuilder-heading","form":"pagebuilder_heading_form","menu_section":"elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"default"},"heading_type":{"default":"h2"},"heading_text":{"default":""},"viewtype":{"default":""},"heading_text_editer":{"default":""}}},"component":"Magento_PageBuilder\/js\/content-type","preview_component":"Magento_PageBuilder\/js\/content-type\/heading\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"default":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"viewtype","name":"data-heading-mode","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":{"var":"heading_text","converter":"Magento_PageBuilder\/js\/converter\/html\/tag-escaper","preview_converter":null},"css":{"var":"css_classes","filter":[]},"tag":{"var":"heading_type","converter":null}},"heading_text_editer":{"style":[],"attributes":[],"html":{"var":"heading_text_editer","converter":null,"preview_converter":null},"css":[],"tag":[]}},"converters":[],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/heading\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/heading\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":[],"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_tabs',
            'serialize_data' => '{"name":"tabs","label":"Tabs","icon":"icon-pagebuilder-tabs","form":"pagebuilder_tabs_form","menu_section":"layout","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":"1"},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"default"},"default_active":{"default":""},"min_height":{"default":"300"},"navigation_alignment":{"default":"left"}}},"component":"Magento_PageBuilder\/js\/content-type-collection","preview_component":"Magento_PageBuilder\/js\/content-type\/tabs\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master-collection","allowed_parents":["root-container","row","column"],"appearances":{"default":{"elements":{"main":{"style":[{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"default_active","name":"data-active-tab","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"css_classes","filter":["tab-align-left","tab-align-center","tab-align-right"]},"tag":[]},"headers":{"style":[{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"}],"attributes":[],"html":[],"css":[],"tag":[]},"navigation":{"style":[{"var":"navigation_alignment","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"}],"attributes":[],"html":[],"css":[],"tag":[]},"content":{"style":[{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"min_height","name":"min_height","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"}],"attributes":[],"html":[],"css":[],"tag":[]}},"converters":[{"name":"header_alignment_class","component":"Magento_PageBuilder\/js\/content-type\/tabs\/mass-converter\/header-alignment","config":{"navigation_alignment_variable":"navigation_alignment"}}],"preview_template":"Magento_PageBuilder\/content-type\/tabs\/default\/preview","master_template":"Magento_PageBuilder\/content-type\/tabs\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":{"mobile":{"form":"pagebuilder_tabs_mobile_form","fields":{"default":{"margins_and_padding":{"default":""},"min_height":{"default":""}}}},"tablet":{"form":"pagebuilder_tabs_tablet_form","fields":{"default":{"margins_and_padding":{"default":""}}}}},"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_products',
            'serialize_data' => '{"name":"products","label":"Products","icon":"icon-pagebuilder-products","form":"pagebuilder_products_form","menu_section":"add_content","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"grid"},"condition_option":{"default":""},"category_ids":{"default":""},"sku":{"default":""},"sort_order":{"default":"position"},"products_count":{"default":"5"},"product_totals":{"default":"of ${ $.totalProductCount } total"}},"carousel-appearance":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"carousel"},"condition_option":{"default":""},"category_ids":{"default":""},"sku":{"default":""},"sort_order":{"default":"position"},"product_totals":{"default":"of ${ $.totalProductCount } total"},"carousel_products_count":{"default":"20"},"carousel_mode":{"default":"default"},"autoplay":{"default":"false"},"autoplay_speed":{"default":"4000"},"is_infinite":{"default":"false"},"show_arrows":{"default":"false"},"show_dots":{"default":"true"}}},"component":"Magento_PageBuilder\/js\/content-type","preview_component":"Magento_PageBuilder\/js\/content-type\/products\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"grid":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":"Magento_PageBuilder\/js\/converter\/style\/color","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":{"var":"html","converter":null,"preview_converter":"Magento_PageBuilder\/js\/converter\/attribute\/preview\/store-id"},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[{"name":"widget_directive","component":"Magento_PageBuilder\/js\/content-type\/products\/mass-converter\/widget-directive","config":{"html_variable":"html"}}],"preview_template":"Magento_PageBuilder\/content-type\/products\/grid\/preview","master_template":"Magento_PageBuilder\/content-type\/products\/grid\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"},"carousel":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":"Magento_PageBuilder\/js\/converter\/style\/color","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay","name":"data-autoplay","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay_speed","name":"data-autoplay-speed","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"is_infinite","name":"data-infinite-loop","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_arrows","name":"data-show-arrows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_dots","name":"data-show-dots","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"carousel_mode","name":"data-carousel-mode","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"name":"data-center-padding","value":"90px","static":true}],"html":{"var":"html","converter":null,"preview_converter":"Magento_PageBuilder\/js\/converter\/attribute\/preview\/store-id"},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[{"name":"widget_directive","component":"Magento_PageBuilder\/js\/content-type\/products\/mass-converter\/carousel-widget-directive","config":{"html_variable":"html"}}],"preview_template":"Magento_PageBuilder\/content-type\/products\/grid\/preview","master_template":"Magento_PageBuilder\/content-type\/products\/grid\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":null,"form":"pagebuilder_products_carousel_form"}},"breakpoints":[],"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_tab-item',
            'serialize_data' => '{"name":"tab-item","label":"Tab","icon":"icon-pagebuilder-tabs","form":"pagebuilder_tab_item_form","menu_section":"layout","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"background_color":{"default":""},"background_image":{"default":""},"mobile_image":{"default":""},"background_size":{"default":"cover"},"background_position":{"default":"left top"},"background_attachment":{"default":"scroll"},"background_repeat":{"default":"no-repeat"},"appearance":{"default":"default"},"tab_name":{"default":""},"min_height":{"default":""},"justify_content":{"default":"flex-start"}}},"component":"Magento_PageBuilder\/js\/content-type-collection","preview_component":"Magento_PageBuilder\/js\/content-type\/tab-item\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master-collection","allowed_parents":["tabs"],"appearances":{"default":{"elements":{"main":{"style":[{"var":"background_color","name":"background_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"background_image","name":"background_image","converter":"Magento_PageBuilder\/js\/converter\/style\/background-image","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/background-image","persistence_mode":"write","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"background_position","name":"background_position","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"background_size","name":"background_size","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"background_repeat","name":"background_repeat","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"background_attachment","name":"background_attachment","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"justify_content","name":"justify_content","converter":null,"preview_converter":null,"persistence_mode":"read","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"min_height","name":"min_height","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":"Magento_PageBuilder\/js\/content-type\/row\/converter\/style\/margins","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":"Magento_PageBuilder\/js\/content-type\/row\/converter\/style\/paddings","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"tab_name","name":"data-tab-name","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"background_images","name":"data-background-images","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"css_classes","filter":[]},"tag":[]},"container":{"style":[{"var":"justify_content","name":"justify_content","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"name":"display","value":"flex","static":true},{"name":"flex_direction","value":"column","static":true}],"attributes":[],"html":[],"css":[],"tag":[]}},"converters":[{"name":"background_images","component":"Magento_PageBuilder\/js\/mass-converter\/background-images","config":{"attribute_name":"background_images","desktop_image_variable":"background_image","mobile_image_variable":"mobile_image"}}],"preview_template":"Magento_PageBuilder\/content-type\/tab-item\/default\/preview","master_template":"Magento_PageBuilder\/content-type\/tab-item\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":{"mobile":{"form":"pagebuilder_tab_item_mobile_form","fields":{"default":{"min_height":{"default":""}}}}},"additional_data":[],"is_system":false}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_category_thumbnail_image',
            'serialize_data' => '{"name":"category_thumbnail_image","label":"Category Thumbnail","icon":"icon-pagebuilder-category-thumbnail-image","form":"pagebuilder_category_thumbnail_image_form","menu_section":"blueskytechco_page_builder_custom_elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"grid"},"template_id":{"default":"default"},"category_ids":{"default":""},"title":{"default":""},"short_description":{"default":""},"space_between_item":{"default":"30"},"image_hover_effects":{"default":"none"}},"carousel-appearance":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"carousel"},"template_id":{"default":"default"},"category_ids":{"default":""},"title":{"default":""},"short_description":{"default":""},"space_between_item":{"default":"30"},"image_hover_effects":{"default":"none"},"template_carousel_id":{"default":"carousel"},"carousel_mode":{"default":"default"},"autoplay":{"default":"false"},"autoplay_speed":{"default":"4000"},"is_infinite":{"default":"false"},"show_arrows":{"default":"false"},"show_dots":{"default":"true"},"slick_rows":{"default":"1"},"margin_item":{"default":"30"},"col_xxl":{"default":"6"},"col_xl":{"default":"5"},"col_lg":{"default":"4"},"col_md":{"default":"3"},"col_sm":{"default":"2"},"col_xs":{"default":"2"}}},"component":"Magento_PageBuilder\/js\/content-type","preview_component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/category-thumbnail-image\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"grid":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":"Magento_PageBuilder\/js\/converter\/style\/color","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":{"var":"html","converter":null,"preview_converter":"Magento_PageBuilder\/js\/converter\/attribute\/preview\/store-id"},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[{"name":"widget_directive","component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/category-thumbnail-image\/mass-converter\/widget-directive","config":{"html_variable":"html"}}],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/category-thumbnail-image\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/category-thumbnail-image\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"},"carousel":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":"Magento_PageBuilder\/js\/converter\/style\/color","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay","name":"data-autoplay","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay_speed","name":"data-autoplay-speed","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"is_infinite","name":"data-infinite-loop","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_arrows","name":"data-show-arrows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_dots","name":"data-show-dots","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"carousel_mode","name":"data-carousel-mode","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"slick_rows","name":"data-slick-rows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xxl","name":"data-col-xxl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xl","name":"data-col-xl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_lg","name":"data-col-lg","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_md","name":"data-col-md","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_sm","name":"data-col-sm","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xs","name":"data-col-xs","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"name":"data-center-padding","value":"90px","static":true}],"html":{"var":"html","converter":null,"preview_converter":"Magento_PageBuilder\/js\/converter\/attribute\/preview\/store-id"},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[{"name":"widget_directive","component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/category-thumbnail-image\/mass-converter\/carousel-widget-directive","config":{"html_variable":"html"}}],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/category-thumbnail-image\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/category-thumbnail-image\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":null,"form":"pagebuilder_category_thumbnail_image_carousel_form"}},"breakpoints":{"mobile":{"form":"pagebuilder_category_thumbnail_image_mobile_form","fields":{"default":{"margins_and_padding":{"default":""}}}},"tablet":{"form":"pagebuilder_category_thumbnail_image_tablet_form","fields":{"default":{"margins_and_padding":{"default":""}}}}},"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_testimonial',
            'serialize_data' => '{"name":"testimonial","label":"Testimonial","icon":"icon-pagebuilder-testimonial","form":"pagebuilder_testimonial_form","menu_section":"blueskytechco_page_builder_custom_elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"carousel"},"testimonial_id":{"default":""},"template_id":{"default":"default"},"title":{"default":""},"short_description":{"default":""},"image_hover_effects":{"default":"none"},"carousel_mode":{"default":"default"},"autoplay":{"default":"false"},"autoplay_speed":{"default":"4000"},"is_infinite":{"default":"false"},"show_arrows":{"default":"false"},"show_dots":{"default":"true"},"slick_rows":{"default":"1"},"margin_item":{"default":"30"},"col_xxl":{"default":"6"},"col_xl":{"default":"5"},"col_lg":{"default":"4"},"col_md":{"default":"3"},"col_sm":{"default":"2"},"col_xs":{"default":"2"}}},"component":"Magento_PageBuilder\/js\/content-type","preview_component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/testimonial\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"carousel":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":"Magento_PageBuilder\/js\/converter\/style\/color","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay","name":"data-autoplay","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay_speed","name":"data-autoplay-speed","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"is_infinite","name":"data-infinite-loop","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_arrows","name":"data-show-arrows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_dots","name":"data-show-dots","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"carousel_mode","name":"data-carousel-mode","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"slick_rows","name":"data-slick-rows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xxl","name":"data-col-xxl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xl","name":"data-col-xl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_lg","name":"data-col-lg","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_md","name":"data-col-md","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_sm","name":"data-col-sm","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xs","name":"data-col-xs","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"name":"data-center-padding","value":"90px","static":true}],"html":{"var":"html","converter":null,"preview_converter":"Magento_PageBuilder\/js\/converter\/attribute\/preview\/store-id"},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[{"name":"widget_directive","component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/testimonial\/mass-converter\/widget-directive","config":{"html_variable":"html"}}],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/testimonial\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/testimonial\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":{"mobile":{"form":"pagebuilder_testimonial_mobile_form","fields":{"default":{"margins_and_padding":{"default":""}}}},"tablet":{"form":"pagebuilder_testimonial_tablet_form","fields":{"default":{"margins_and_padding":{"default":""}}}}},"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_buttons',
            'serialize_data' => '{"name":"buttons","label":"Buttons","icon":"icon-pagebuilder-button","form":"pagebuilder_buttons_form","menu_section":"elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"inline"},"is_same_width":{"default":"false"}}},"component":"Magento_PageBuilder\/js\/content-type-collection","preview_component":"Magento_PageBuilder\/js\/content-type\/buttons\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master-collection","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"inline":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/content-type\/buttons\/converter\/style\/display\/boolean","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"is_same_width","name":"data-same-width","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[],"preview_template":"Magento_PageBuilder\/content-type\/buttons\/inline\/preview","master_template":"Magento_PageBuilder\/content-type\/buttons\/inline\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"},"stacked":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/content-type\/buttons\/converter\/style\/display\/flex","preview_converter":"Magento_PageBuilder\/js\/content-type\/buttons\/converter\/style\/preview\/display\/flex","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"},{"name":"flex_direction","value":"column","static":true}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"is_same_width","name":"data-same-width","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[],"preview_template":"Magento_PageBuilder\/content-type\/buttons\/stacked\/preview","master_template":"Magento_PageBuilder\/content-type\/buttons\/stacked\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":null}},"breakpoints":[],"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_product_advanced',
            'serialize_data' => '{"name":"product_advanced","label":"Product Advanced","icon":"icon-pagebuilder-product-advanced","form":"pagebuilder_product_advanced_form","menu_section":"blueskytechco_page_builder_custom_elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"grid"},"template_id":{"default":"default"},"product_type":{"default":""},"category_ids":{"default":""},"number_products":{"default":"8"},"title":{"default":""},"short_description":{"default":""},"space_between_item":{"default":"30"},"col_xxl":{"default":"2"},"col_xl":{"default":"15"},"col_lg":{"default":"3"},"col_md":{"default":"4"},"col_sm":{"default":"6"},"col_xs":{"default":"6"}},"carousel-appearance":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"carousel"},"template_id":{"default":"default"},"product_type":{"default":""},"category_ids":{"default":""},"number_products":{"default":"8"},"title":{"default":""},"short_description":{"default":""},"space_between_item":{"default":"30"},"template_carousel_id":{"default":"carousel"},"col_xxl":{"default":"6"},"col_xl":{"default":"5"},"col_lg":{"default":"4"},"col_md":{"default":"3"},"col_sm":{"default":"2"},"col_xs":{"default":"2"},"carousel_mode":{"default":"default"},"autoplay":{"default":"false"},"autoplay_speed":{"default":"4000"},"is_infinite":{"default":"false"},"show_arrows":{"default":"false"},"show_dots":{"default":"true"},"slick_rows":{"default":"1"},"margin_item":{"default":"30"}}},"component":"Magento_PageBuilder\/js\/content-type","preview_component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/product-advanced\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"grid":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":"Magento_PageBuilder\/js\/converter\/style\/color","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":{"var":"html","converter":null,"preview_converter":"Magento_PageBuilder\/js\/converter\/attribute\/preview\/store-id"},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[{"name":"widget_directive","component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/product-advanced\/mass-converter\/widget-directive","config":{"html_variable":"html"}}],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/product-advanced\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/product-advanced\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"},"carousel":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":"Magento_PageBuilder\/js\/converter\/style\/color","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay","name":"data-autoplay","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay_speed","name":"data-autoplay-speed","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"is_infinite","name":"data-infinite-loop","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_arrows","name":"data-show-arrows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_dots","name":"data-show-dots","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"carousel_mode","name":"data-carousel-mode","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"slick_rows","name":"data-slick-rows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xxl","name":"data-col-xxl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xl","name":"data-col-xl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_lg","name":"data-col-lg","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_md","name":"data-col-md","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_sm","name":"data-col-sm","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xs","name":"data-col-xs","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"name":"data-center-padding","value":"90px","static":true}],"html":{"var":"html","converter":null,"preview_converter":"Magento_PageBuilder\/js\/converter\/attribute\/preview\/store-id"},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[{"name":"widget_directive","component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/product-advanced\/mass-converter\/carousel-widget-directive","config":{"html_variable":"html"}}],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/product-advanced\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/product-advanced\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":null,"form":"pagebuilder_product_advanced_carousel_form"}},"breakpoints":{"mobile":{"form":"pagebuilder_product_advanced_mobile_form","fields":{"default":{"margins_and_padding":{"default":""}}}},"tablet":{"form":"pagebuilder_product_advanced_tablet_form","fields":{"default":[]}}},"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_slider',
            'serialize_data' => '{"name":"slider","label":"Slider","icon":"icon-pagebuilder-slider","form":"pagebuilder_slider_form","menu_section":"media","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"default"},"min_height":{"default":"300px"},"autoplay":{"default":"false"},"autoplay_speed":{"default":"4000"},"fade":{"default":"false"},"is_infinite":{"default":"false"},"show_arrows":{"default":"false"},"show_dots":{"default":"true"}}},"component":"Magento_PageBuilder\/js\/content-type-collection","preview_component":"Magento_PageBuilder\/js\/content-type\/slider\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master-collection","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"default":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"min_height","name":"min_height","converter":"Magento_PageBuilder\/js\/converter\/style\/min-height","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay","name":"data-autoplay","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay_speed","name":"data-autoplay-speed","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"fade","name":"data-fade","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"is_infinite","name":"data-infinite-loop","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_arrows","name":"data-show-arrows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_dots","name":"data-show-dots","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[],"preview_template":"Magento_PageBuilder\/content-type\/slider\/default\/preview","master_template":"Magento_PageBuilder\/content-type\/slider\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":{"mobile":{"form":"pagebuilder_slider_mobile_form","fields":{"default":{"min_height":{"default":""}}}}},"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_divider',
            'serialize_data' => '{"name":"divider","label":"Divider","icon":"icon-pagebuilder-divider","form":"pagebuilder_divider_form","menu_section":"elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"default"},"line_color":{"default":"#CECECE"},"line_thickness":{"default":"1"},"line_width":{"default":"100%"}}},"component":"Magento_PageBuilder\/js\/content-type","preview_component":"Magento_PageBuilder\/js\/content-type\/divider\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"default":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"css_classes","filter":[]},"tag":[]},"line":{"style":[{"var":"line_width","name":"width","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"line_thickness","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"line_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"name":"display","value":"inline-block","static":true}],"attributes":[],"html":[],"css":[],"tag":[]}},"converters":[],"preview_template":"Magento_PageBuilder\/content-type\/divider\/default\/preview","master_template":"Magento_PageBuilder\/content-type\/divider\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":[],"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_map',
            'serialize_data' => '{"name":"map","label":"Map","icon":"icon-pagebuilder-map","form":"pagebuilder_map_form","menu_section":"media","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"default"},"height":{"default":"300"},"show_controls":{"default":"true"}}},"component":"Magento_PageBuilder\/js\/content-type","preview_component":"Magento_PageBuilder\/js\/content-type\/map\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"default":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"},{"var":"height","name":"height","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_controls","name":"data-show-controls","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"locations","name":"data-locations","converter":"Magento_PageBuilder\/js\/content-type\/map\/converter\/attribute\/locations","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[],"preview_template":"Magento_PageBuilder\/content-type\/map\/default\/preview","master_template":"Magento_PageBuilder\/content-type\/map\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":[],"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_gallery',
            'serialize_data' => '{"name":"gallery","label":"Gallery","icon":"icon-pagebuilder-gallery","form":"pagebuilder_gallery_form","menu_section":"blueskytechco_page_builder_custom_elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"default"},"layout_design":{"default":"grid"},"action_click":{"default":"photo_swipe"},"space_between_item":{"default":"30"},"carousel_mode":{"default":"default"},"autoplay":{"default":"false"},"autoplay_speed":{"default":"4000"},"is_infinite":{"default":"false"},"show_arrows":{"default":"false"},"show_dots":{"default":"true"},"slick_rows":{"default":"1"},"col_xxl":{"default":"2"},"col_xl":{"default":"2"},"col_lg":{"default":"3"},"col_md":{"default":"4"},"col_sm":{"default":"6"},"col_xs":{"default":"6"}}},"component":"Magento_PageBuilder\/js\/content-type-collection","preview_component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/gallery\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master-collection","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"default":{"elements":{"main":{"style":[{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"layout_design","name":"data-layout-design","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"action_click","name":"data-action-click","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"space_between_item","name":"data-space-between-item","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay","name":"data-autoplay","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay_speed","name":"data-autoplay-speed","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"is_infinite","name":"data-infinite-loop","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_arrows","name":"data-show-arrows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_dots","name":"data-show-dots","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"carousel_mode","name":"data-carousel-mode","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"slick_rows","name":"data-slick-rows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xxl","name":"data-col-xxl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xl","name":"data-col-xl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_lg","name":"data-col-lg","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_md","name":"data-col-md","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_sm","name":"data-col-sm","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xs","name":"data-col-xs","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/gallery\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/gallery\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":{"mobile":{"form":"pagebuilder_gallery_mobile_form","fields":{"default":{"margins_and_padding":{"default":""}}}},"tablet":{"form":"pagebuilder_gallery_tablet_form","fields":{"default":{"margins_and_padding":{"default":""}}}}},"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_faq',
            'serialize_data' => '{"name":"faq","label":"FAQs","icon":"icon-pagebuilder-faq","form":"pagebuilder_faq_form","menu_section":"blueskytechco_page_builder_custom_elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"default"},"template_id":{"default":"default"},"title":{"default":""},"shortdescription":{"default":""}}},"component":"Magento_PageBuilder\/js\/content-type-collection","preview_component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/faq\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master-collection","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"default":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"template_id","name":"data-template-id","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":[],"css":{"var":"css_classes","filter":[]},"tag":[]},"title":{"style":[],"attributes":[],"html":{"var":"title","converter":null,"preview_converter":null},"css":[],"tag":[]},"shortdescription":{"style":[],"attributes":[],"html":{"var":"shortdescription","converter":null,"preview_converter":null},"css":[],"tag":[]}},"converters":[],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/faq\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/faq\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":{"mobile":{"form":"pagebuilder_faq_mobile_form","fields":{"default":{"margins_and_padding":{"default":""}}}},"tablet":{"form":"pagebuilder_faq_tablet_form","fields":{"default":{"margins_and_padding":{"default":""}}}}},"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_html',
            'serialize_data' => '{"name":"html","label":"HTML Code","icon":"icon-pagebuilder-code","form":"pagebuilder_html_form","menu_section":"elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"default"},"html":{"default":""}}},"component":"Magento_PageBuilder\/js\/content-type","preview_component":"Magento_PageBuilder\/js\/content-type\/html\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":["root-container","row","column","tab-item"],"appearances":{"default":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":{"var":"html","converter":"Magento_PageBuilder\/js\/converter\/html\/decode","preview_converter":null},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[],"preview_template":"Magento_PageBuilder\/content-type\/html\/default\/preview","master_template":"Magento_PageBuilder\/content-type\/html\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"}},"breakpoints":[],"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_productcountdowntimers',
            'serialize_data' => '{"name":"productcountdowntimers","label":"Product Countdown Timers","icon":"icon-pagebuilder-productcountdowntimers","form":"pagebuilder_productcountdowntimers_form","menu_section":"blueskytechco_page_builder_custom_elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"grid"},"product_ids":{"default":""},"grid_layout":{"default":"default"},"title":{"default":""},"short_description":{"default":""},"space_between_item":{"default":"30"},"desgin":{"default":"dark"},"countdown_day":{"default":"d"},"countdown_hour":{"default":"h"},"countdown_minute":{"default":"m"},"countdown_second":{"default":"s"},"col_xxl":{"default":"2"},"col_xl":{"default":"15"},"col_lg":{"default":"3"},"col_md":{"default":"4"},"col_sm":{"default":"6"},"col_xs":{"default":"6"}},"carousel-appearance":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"carousel"},"product_ids":{"default":""},"grid_layout":{"default":"default"},"title":{"default":""},"short_description":{"default":""},"space_between_item":{"default":"30"},"desgin":{"default":"dark"},"countdown_day":{"default":"d"},"countdown_hour":{"default":"h"},"countdown_minute":{"default":"m"},"countdown_second":{"default":"s"},"col_xxl":{"default":"6"},"col_xl":{"default":"5"},"col_lg":{"default":"4"},"col_md":{"default":"3"},"col_sm":{"default":"2"},"col_xs":{"default":"2"},"carousel_mode":{"default":"default"},"autoplay":{"default":"false"},"autoplay_speed":{"default":"4000"},"is_infinite":{"default":"false"},"show_arrows":{"default":"false"},"show_dots":{"default":"true"},"slick_rows":{"default":"1"},"margin_item":{"default":"30"}}},"component":"Magento_PageBuilder\/js\/content-type","preview_component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/productcountdowntimers\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"grid":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":"Magento_PageBuilder\/js\/converter\/style\/color","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_day","name":"data-countdown-text-day","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_hour","name":"data-countdown-text-hour","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_minute","name":"data-countdown-text-minute","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_second","name":"data-countdown-text-second","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":{"var":"html","converter":null,"preview_converter":"Magento_PageBuilder\/js\/converter\/attribute\/preview\/store-id"},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[{"name":"widget_directive","component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/productcountdowntimers\/mass-converter\/widget-directive","config":{"html_variable":"html"}}],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/productcountdowntimers\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/productcountdowntimers\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"},"carousel":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":"Magento_PageBuilder\/js\/converter\/style\/color","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay","name":"data-autoplay","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay_speed","name":"data-autoplay-speed","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"is_infinite","name":"data-infinite-loop","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_arrows","name":"data-show-arrows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_dots","name":"data-show-dots","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"carousel_mode","name":"data-carousel-mode","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"slick_rows","name":"data-slick-rows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xxl","name":"data-col-xxl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xl","name":"data-col-xl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_lg","name":"data-col-lg","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_md","name":"data-col-md","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_sm","name":"data-col-sm","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xs","name":"data-col-xs","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_day","name":"data-countdown-text-day","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_hour","name":"data-countdown-text-hour","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_minute","name":"data-countdown-text-minute","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_second","name":"data-countdown-text-second","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"name":"data-center-padding","value":"90px","static":true}],"html":{"var":"html","converter":null,"preview_converter":"Magento_PageBuilder\/js\/converter\/attribute\/preview\/store-id"},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[{"name":"widget_directive","component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/productcountdowntimers\/mass-converter\/carousel-widget-directive","config":{"html_variable":"html"}}],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/productcountdowntimers\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/productcountdowntimers\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":null,"form":"pagebuilder_productcountdowntimers_carousel_form"}},"breakpoints":{"mobile":{"form":"pagebuilder_productcountdowntimers_grid_mobile_form","fields":{"default":{"margins_and_padding":{"default":""}}}},"tablet":{"form":"pagebuilder_productcountdowntimers_grid_tablet_form","fields":{"default":{"margins_and_padding":{"default":""}}}}},"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_daily_deal',
            'serialize_data' => '{"name":"daily_deal","label":"Daily Deal","icon":"icon-pagebuilder-daily-deal","form":"pagebuilder_daily_deal_form","menu_section":"blueskytechco_page_builder_custom_elements","fields":{"default":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"grid"},"category_id":{"default":""},"number_products":{"default":"8"},"hide_products":{"default":"false"},"title":{"default":""},"short_description":{"default":""},"daily_style":{"default":"default"},"space_between_item":{"default":"30"},"countdown_text":{"default":"End in:"},"countdown_data":{"default":"2022\/06\/20 23:59:59"},"desgin":{"default":"dark"},"countdown_day":{"default":"d"},"countdown_hour":{"default":"h"},"countdown_minute":{"default":"m"},"countdown_second":{"default":"s"},"col_xxl":{"default":"2"},"col_xl":{"default":"15"},"col_lg":{"default":"3"},"col_md":{"default":"4"},"col_sm":{"default":"6"},"col_xs":{"default":"6"}},"carousel-appearance":{"text_align":{"default":""},"border":{"default":"_default"},"border_color":{"default":""},"border_width":{"default":""},"border_radius":{"default":""},"css_classes":{"default":""},"margins_and_padding":{"default":""},"appearance":{"default":"carousel"},"category_id":{"default":""},"number_products":{"default":"8"},"hide_products":{"default":"false"},"title":{"default":""},"short_description":{"default":""},"daily_style":{"default":"default"},"space_between_item":{"default":"30"},"countdown_text":{"default":"End in:"},"countdown_data":{"default":"2022\/06\/20 23:59:59"},"desgin":{"default":"dark"},"countdown_day":{"default":"d"},"countdown_hour":{"default":"h"},"countdown_minute":{"default":"m"},"countdown_second":{"default":"s"},"col_xxl":{"default":"6"},"col_xl":{"default":"5"},"col_lg":{"default":"4"},"col_md":{"default":"3"},"col_sm":{"default":"2"},"col_xs":{"default":"2"},"carousel_mode":{"default":"default"},"autoplay":{"default":"false"},"autoplay_speed":{"default":"4000"},"is_infinite":{"default":"false"},"show_arrows":{"default":"false"},"show_dots":{"default":"true"},"slick_rows":{"default":"1"},"margin_item":{"default":"30"}}},"component":"Magento_PageBuilder\/js\/content-type","preview_component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/daily_deal\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":["column","row","tab-item","cbanner"],"appearances":{"grid":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":"Magento_PageBuilder\/js\/converter\/style\/color","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"daily_style","name":"data-daily-style","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_day","name":"data-countdown-text-day","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_hour","name":"data-countdown-text-hour","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_minute","name":"data-countdown-text-minute","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_second","name":"data-countdown-text-second","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"}],"html":{"var":"html","converter":null,"preview_converter":"Magento_PageBuilder\/js\/converter\/attribute\/preview\/store-id"},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[{"name":"widget_directive","component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/daily_deal\/mass-converter\/widget-directive","config":{"html_variable":"html"}}],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/daily_deal\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/daily_deal\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":"true"},"carousel":{"elements":{"main":{"style":[{"var":"text_align","name":"text_align","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border","name":"border_style","converter":"Magento_PageBuilder\/js\/converter\/style\/border-style","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_color","name":"border_color","converter":"Magento_PageBuilder\/js\/converter\/style\/color","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_width","name":"border_width","converter":"Magento_PageBuilder\/js\/converter\/style\/border-width","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"border_radius","name":"border_radius","converter":"Magento_PageBuilder\/js\/converter\/style\/remove-px","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"display","name":"display","converter":"Magento_PageBuilder\/js\/converter\/style\/display","preview_converter":"Magento_PageBuilder\/js\/converter\/style\/preview\/display","persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/style-property-reader"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/margins","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/margins"},{"var":"margins_and_padding","name":null,"converter":"Magento_PageBuilder\/js\/converter\/style\/paddings","preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/paddings"}],"attributes":[{"var":"name","name":"data-content-type","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"appearance","name":"data-appearance","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay","name":"data-autoplay","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"autoplay_speed","name":"data-autoplay-speed","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"is_infinite","name":"data-infinite-loop","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_arrows","name":"data-show-arrows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"show_dots","name":"data-show-dots","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"carousel_mode","name":"data-carousel-mode","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"slick_rows","name":"data-slick-rows","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xxl","name":"data-col-xxl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xl","name":"data-col-xl","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_lg","name":"data-col-lg","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_md","name":"data-col-md","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_sm","name":"data-col-sm","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"col_xs","name":"data-col-xs","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_day","name":"data-countdown-text-day","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_hour","name":"data-countdown-text-hour","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_minute","name":"data-countdown-text-minute","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"var":"countdown_second","name":"data-countdown-text-second","converter":null,"preview_converter":null,"persistence_mode":"readwrite","reader":"Magento_PageBuilder\/js\/property\/attribute-reader"},{"name":"data-center-padding","value":"90px","static":true}],"html":{"var":"html","converter":null,"preview_converter":"Magento_PageBuilder\/js\/converter\/attribute\/preview\/store-id"},"css":{"var":"css_classes","filter":[]},"tag":[]}},"converters":[{"name":"widget_directive","component":"Blueskytechco_PageBuilderCustom\/js\/content-type\/daily_deal\/mass-converter\/carousel-widget-directive","config":{"html_variable":"html"}}],"preview_template":"Blueskytechco_PageBuilderCustom\/content-type\/daily_deal\/default\/preview","master_template":"Blueskytechco_PageBuilderCustom\/content-type\/daily_deal\/default\/master","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","default":null,"form":"pagebuilder_daily_deal_carousel_form"}},"breakpoints":{"mobile":{"form":"pagebuilder_daily_deal_grid_mobile_form","fields":{"default":{"margins_and_padding":{"default":""}}}},"tablet":{"form":"pagebuilder_daily_deal_grid_tablet_form","fields":{"default":{"margins_and_padding":{"default":""}}}}},"additional_data":[],"is_system":true}'
        ];
        $data[] = [
            'cache_identifier' => 'CONTENT_TYPE_root-container',
            'serialize_data' => '{"name":"root-container","label":"Root Container","icon":"","form":"","menu_section":"general","fields":[],"component":"Magento_PageBuilder\/js\/content-type\/root-container\/content-type-collection","preview_component":"Magento_PageBuilder\/js\/content-type\/preview","master_component":"Magento_PageBuilder\/js\/content-type\/master","allowed_parents":[],"appearances":{"default":{"default":"true","reader":"Magento_PageBuilder\/js\/master-format\/read\/configurable","preview_template":"Magento_PageBuilder\/content-type\/root-container\/preview","master_template":"Magento_PageBuilder\/content-type\/master-collection"}},"breakpoints":[],"additional_data":[],"is_system":false}'
        ];
        $data[] = [
            'cache_identifier' => 'WIDGET_BREAKPOINS',
            'serialize_data' => '{"desktop":{"label":"Desktop","stage":true,"default":true,"class":"desktop-switcher","icon":"Magento_PageBuilder::css\/images\/switcher\/switcher-desktop.svg","conditions":{"min-width":"1024px"},"options":{"products":{"default":{"slidesToShow":"5"}}}},"tablet":{"conditions":{"max-width":"1024px","min-width":"768px"},"options":{"products":{"default":{"slidesToShow":"4"},"continuous":{"slidesToShow":"3"}}},"label":"Tablet","stage":true,"default":false,"class":"mobile-switcher","icon":"images\/switcher\/switcher-tablet.svg","media":"only screen and (max-width: 1024px)"},"mobile":{"label":"Mobile","stage":true,"class":"mobile-switcher","icon":"Magento_PageBuilder::css\/images\/switcher\/switcher-mobile.svg","media":"only screen and (max-width: 768px)","conditions":{"max-width":"768px","min-width":"640px"},"options":{"products":{"default":{"slidesToShow":"3"}}}},"mobile-small":{"conditions":{"max-width":"640px"},"options":{"products":{"default":{"slidesToShow":"2"},"continuous":{"slidesToShow":"1"}}}}}'
        ];

        foreach($data as $_item){
            $this->_pageBuilderCacheFactory->create()->setData($_item)->save();
        }
    }
}