define([
    'jquery',
    'Magento_Ui/js/modal/modal'
], function ($, modal) {
    'use strict';

    return {
        modalWindow: null,

        /**
         * Create popUp window for provided element
         *
         * @param {HTMLElement} element
         */
        createPopUp: function (element) {
            var options = {
                'type': 'popup',
                'modalClass': 'popup-ajaxsuite ajaxsuite-popup-wrapper',
                'responsive': true,
                'innerScroll': true,
                'buttons': []
            };

            this.modalWindow = element;
            modal(options, $(this.modalWindow));
        },

        /** Show login popup window */
        showModal: function () {
            $(this.modalWindow).modal('openModal').trigger('contentUpdated');
        },
        hideModal: function () {
            if(this.modalWindow)
            {
                $(this.modalWindow).modal('closeModal');
            }
        }
    };
});
